-- Enable CDC for Database
exec sys.sp_cdc_enable_db
exec sys.sp_cdc_disable_db

-- Enable CDC for Customer Table
EXEC sys.sp_cdc_enable_table  
@source_schema = N'dbo',  
@source_name   = N'customers',  
@role_name     = null, --N'MyRole',  
@filegroup_name = N'Primary',  
@supports_net_changes = 1  
GO  

sys.sp_cdc_disable_table   
@source_schema = N'dbo',
@source_name   = N'dimCustomer',
@capture_instance = N'all'

create table dbo.CDC_States (
	[name] nvarchar(256) not null
	, [state] nvarchar(256) not null
	)
go

create unique nonclustered index ix_CDC_States on dbo.CDC_States
	(
	[name] asc
	)
go

truncate table dbo.dimCustomer_cdc
insert into dbo.dimCustomer_cdc select * from dbo.dimCustomer

-- Update Customers
update dbo.customers
set customerName = 'Tailspin Toys (Head Office)' where customerName = 'Tailspin Toys (Home Office)'
--set customerName = 'Tailspin Toys (Home Office)' where customerName = 'Tailspin Toys (Head Office)'

update dbo.customers
set creditlimit = null where customerID = 5
--set creditlimit = 9999 where customerID = 5

declare @begin_time datetime = getdate() - 1;
declare @end_time datetime = GETDATE();  
declare @from_lsn binary(10) = sys.fn_cdc_map_time_to_lsn('smallest greater than or equal', @begin_time);  
declare @to_lsn binary(10) = sys.fn_cdc_map_time_to_lsn('largest less than or equal', @end_time);  

select @begin_time, @end_time, @from_lsn, @to_lsn

select * from cdc.fn_cdc_get_net_changes_dbo_customers(@from_lsn, @to_lsn, 'all with mask');  
